/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.ws.api.uddi.WSBusinessService;
import filenet.ws.api.uddi.WSTModelInstanceInfo;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;

public class WSBindingTemplate {
    private WSUDDIRegistry m_uddiRegistry = null;
    private WSBusinessService m_businessService = null;
    private BindingTemplate m_bindingTemplate = null;
    private Vector m_tModelInstanceInfos = null;
    private CategoryBag m_categoryBag = null;
    private Vector m_categoryVector = null;

    public WSBindingTemplate(WSUDDIRegistry uddiRegistry, WSBusinessService businessService, BindingTemplate bindingTemplate) {
        this.m_uddiRegistry = uddiRegistry;
        this.m_businessService = businessService;
        this.m_bindingTemplate = bindingTemplate;
    }

    public WSBusinessService getBusinessService() {
        return this.m_businessService;
    }

    public String getDescription() {
        Vector v;
        if (this.m_bindingTemplate != null && (v = this.m_bindingTemplate.getDescriptionVector()) != null & v.size() > 0 && v.get(0) != null && v.get(0) instanceof Description) {
            return ((Description)v.get(0)).getValue();
        }
        return null;
    }

    public String getServiceKey() {
        if (this.m_bindingTemplate != null) {
            return this.m_bindingTemplate.getServiceKey();
        }
        return null;
    }

    public String getBindingKey() {
        if (this.m_bindingTemplate != null) {
            return this.m_bindingTemplate.getBindingKey();
        }
        return null;
    }

    public String getAccessPoint() {
        AccessPoint accessPoint;
        if (this.m_bindingTemplate != null && (accessPoint = this.m_bindingTemplate.getAccessPoint()) != null) {
            return accessPoint.getURL();
        }
        return null;
    }

    public String getAccessPointURLType() {
        AccessPoint accessPoint;
        if (this.m_bindingTemplate != null && (accessPoint = this.m_bindingTemplate.getAccessPoint()) != null) {
            return accessPoint.getURLType();
        }
        return null;
    }

    public HostingRedirector getHostingRedictor() {
        if (this.m_bindingTemplate != null) {
            return this.m_bindingTemplate.getHostingRedirector();
        }
        return null;
    }

    public Vector getTModelInstanceInfos() {
        if (this.m_bindingTemplate != null && this.m_tModelInstanceInfos == null) {
            this.m_tModelInstanceInfos = new Vector();
            TModelInstanceDetails tModelInstanceDetails = this.m_bindingTemplate.getTModelInstanceDetails();
            if (tModelInstanceDetails != null) {
                Vector v = tModelInstanceDetails.getTModelInstanceInfoVector();
                TModelInstanceInfo tModelInstanceInfo = null;
                Object obj = null;
                for (int i = 0; i < v.size(); ++i) {
                    obj = v.get(i);
                    if (obj == null || !(obj instanceof TModelInstanceInfo)) continue;
                    tModelInstanceInfo = obj;
                    this.m_tModelInstanceInfos.add(new WSTModelInstanceInfo(this.m_uddiRegistry, this, tModelInstanceInfo));
                }
            }
        }
        return this.m_tModelInstanceInfos;
    }

    public Vector getTModelKeys() {
        Vector<String> tModelKeys = new Vector<String>();
        Vector tModelInstanceInfos = this.getTModelInstanceInfos();
        if (tModelInstanceInfos != null && tModelInstanceInfos.size() > 0) {
            Object obj = null;
            Object tModelInstanceInfo = null;
            for (int i = 0; i < tModelInstanceInfos.size(); ++i) {
                String key;
                obj = tModelInstanceInfos.get(i);
                if (obj == null || !(obj instanceof WSTModelInstanceInfo) || (key = ((WSTModelInstanceInfo)obj).getTModelKey()) == null) continue;
                tModelKeys.add(key);
            }
        }
        return tModelKeys;
    }
}

